/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.entity;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.api.common.data.IQuests;
import dev.toma.gunsrpg.api.common.data.ITraderStatus;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.quests.QuestProperties;
import dev.toma.gunsrpg.common.quests.QuestSystem;
import dev.toma.gunsrpg.common.quests.mayor.ReputationStatus;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.Quest;
import dev.toma.gunsrpg.common.quests.quest.QuestManager;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestStatus;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.QuestTypes;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.S2C_OpenQuestScreen;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;

public class MayorEntity
extends CreatureEntity {
    private final Map<UUID, ListedQuests> playerQuests;
    private long refreshAtWorldTime;

    public MayorEntity(EntityType<? extends MayorEntity> type, World world) {
        super(type, world);
        this.func_110163_bv();
        this.playerQuests = new HashMap<UUID, ListedQuests>();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        long diff = this.getRemainingRestockTime();
        if (diff <= 0L) {
            this.refreshAtWorldTime = this.field_70170_p.func_82737_E() + GunsRPG.config.quests.questRefreshInterval;
            this.playerQuests.clear();
            GunsRPG.log.debug(QuestSystem.MARKER, "Mayor {} quests expired", (Object)this);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity p_82167_1_) {
    }

    public void func_110162_b(Entity entity, boolean bool) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76380_i) {
            this.func_70665_d(source, amount);
            return true;
        }
        return false;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        IPlayerData data = PlayerData.getUnsafe(player);
        IQuests quests = data.getQuests();
        if (player.func_213453_ef()) {
            quests.getActiveQuest().ifPresent(quest -> {
                ItemStack stack = player.func_184586_b(hand);
                PropertyContext holder = PropertyContext.create();
                holder.setProperty(QuestProperties.PLAYER, player);
                holder.setProperty(QuestProperties.USED_ITEM, stack);
                holder.setProperty(QuestProperties.UUID, this.func_110124_au());
                quest.trigger(Trigger.ITEM_HANDOVER, holder);
            });
        } else if (!this.field_70170_p.field_72995_K) {
            UUID uuid = player.func_110124_au();
            ListedQuests traderQuests = this.playerQuests.get(uuid);
            UUID traderId = this.func_110124_au();
            ITraderStatus status = quests.getTraderStandings().getStatusWithTrader(traderId);
            if (!this.playerQuests.containsKey(uuid) || traderQuests == null) {
                traderQuests = ListedQuests.generate(traderId, status.getReputation());
                this.playerQuests.put(uuid, traderQuests);
            }
            ReputationStatus reputationStatus = ReputationStatus.getStatus(status.getReputation());
            NetworkManager.sendClientPacket((ServerPlayerEntity)player, new S2C_OpenQuestScreen(reputationStatus, traderQuests, this.func_145782_y(), this.refreshAtWorldTime));
        }
        return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, ListedQuests> entry : this.playerQuests.entrySet()) {
            UUID uuid = entry.getKey();
            ListedQuests quests = entry.getValue();
            CompoundNBT data = new CompoundNBT();
            data.func_186854_a("player", uuid);
            data.func_218657_a("quests", (INBT)quests.toNbt());
            list.add((Object)data);
        }
        nbt.func_218657_a("questListings", (INBT)list);
        nbt.func_74772_a("plannedRefresh", this.refreshAtWorldTime);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.playerQuests.clear();
        ListNBT list = nbt.func_150295_c("questListings", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT data = list.func_150305_b(i);
            UUID player = data.func_186857_a("player");
            ListNBT listedQuests = data.func_150295_c("quests", 10);
            this.playerQuests.put(player, ListedQuests.loadNbt(listedQuests));
        }
        this.refreshAtWorldTime = nbt.func_74763_f("plannedRefresh");
    }

    public long getRemainingRestockTime() {
        return this.refreshAtWorldTime - this.field_70170_p.func_82737_E();
    }

    public ListedQuests getQuests(UUID playerId) {
        return this.playerQuests.get(playerId);
    }

    public void setClientTimer(long refreshAtWorldTime) {
        this.refreshAtWorldTime = refreshAtWorldTime;
    }

    public long getCurrentRefreshTarget() {
        return this.refreshAtWorldTime;
    }

    public static final class ListedQuests {
        public static final int QUEST_COUNT = 5;
        private Quest<?>[] quests;

        public ListedQuests(Quest<?>[] quests) {
            this.quests = quests;
        }

        public static ListedQuests loadNbt(ListNBT nbt) {
            return new ListedQuests((Quest[])nbt.stream().map(inbt -> QuestTypes.getFromNbt((CompoundNBT)inbt)).toArray(Quest[]::new));
        }

        public static ListedQuests generate(UUID traderId, float reputation) {
            QuestSystem system = GunsRPG.getModLifecycle().quests();
            QuestManager manager = system.getQuestManager();
            Set<QuestScheme<?>> schemes = manager.getSchemes(5, reputation);
            Quest[] quests = (Quest[])schemes.stream().map(scheme -> ListedQuests.makeQuestFromScheme(scheme, traderId)).toArray(Quest[]::new);
            return new ListedQuests(quests);
        }

        public Quest<?>[] getQuests() {
            return this.quests;
        }

        public void filterActive() {
            this.quests = (Quest[])Arrays.stream(this.quests).filter(quest -> quest.getStatus() == QuestStatus.CREATED).toArray(Quest[]::new);
        }

        public ListNBT toNbt() {
            ListNBT nbt = new ListNBT();
            Arrays.stream(this.quests).map(Quest::serialize).forEach(arg_0 -> nbt.add(arg_0));
            return nbt;
        }

        private static <D extends IQuestData, Q extends Quest<D>> Q makeQuestFromScheme(QuestScheme<D> scheme, UUID traderId) {
            QuestType<D, ?> type = scheme.getQuestType();
            return (Q)type.newQuestInstance(scheme, traderId);
        }
    }
}

